import { Component, OnInit, Input } from '@angular/core';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { Response } from '@angular/http';
import {
  CONCEPT_CARD_POPULATING,
  ENABLE_CONCEPT_CARD_VIEW,
  SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATED
} from '../../../../actions';

import { ConceptServices } from '../../../../services/concept-services';

@Component({
  selector: 'app-concept-card-metadata-relationships-item',
  templateUrl: './concept-card-metadata-relationships-item.component.html',
  styleUrls: ['./concept-card-metadata-relationships-item.component.scss']
})
export class ConceptCardMetadataRelationshipsItemComponent implements OnInit {
  @Input() relationshipObj;
  mouseOveredRelationshipName: boolean;
  mouseOveredRelatedConcept: boolean;
  constructor(
    private conceptServices: ConceptServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getConcept(uri) {
    this.ngRedux.dispatch({
      type: CONCEPT_CARD_POPULATING
    });
    this.ngRedux.dispatch({
      type: ENABLE_CONCEPT_CARD_VIEW
    });
    /* Note: change this method to call populateConceptCard() after API property for URI is in sync */
    this.conceptServices
    .populateConceptCard(null, uri)
    .subscribe(
      (response: Response) => {
        if (response.status === 200) {
          let rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
            type: SET_CARD_DATA,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: SET_CURRENT_CONCEPT_SELECTED,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: NEW_CONCEPT_HISTORY,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: CONCEPT_CARD_POPULATED
          });
        }
    });
  }

  accessConceptFromRelationship(uri) {
    this.conceptServices.getConcept(uri);
  }

  getRelationshipDisplayText(){
    return (this.relationshipObj.relationshipName == null || this.relationshipObj.relationshipName == '' ? 
      this.relationshipObj.relationshipUri : this.relationshipObj.relationshipName);
  }
}
